<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Rest_Mini extends Controller_Rest{

    public function action_index(){
        $response = DB::select('u.id', 'u.username')
            ->from(['users', 'u'])
            ->join(['roles_users', 'ru'])
            ->on('ru.user_id', '=', 'u.id')
            ->join(['roles', 'r'])
            ->on('ru.role_id', '=', 'r.id')
            ->where('r.name', '=', 'mini-user')
            ->execute()
            ->as_array();

        foreach ($response as $k => $user){
            $record = DB::select('id')
                ->from('logpost_mini')
                ->where('user_id', '=', $user['id'])
                ->and_where('id', '=', $this->post['id'])
                ->execute()
                ->as_array();

            if(!empty($record)){
                $response[$k]['selected'] = true;
            }
        }

        $this->response->body(
            json_encode($response)
        );
    }

    public function action_upd(){
        $list = $this->post['list'];
        $id = $this->post['id'];

        $records = DB::select()
            ->from('logpost_mini')
            ->where('id', '=', $id)
            ->execute()
            ->as_array();

        if(empty($records)){
            DB::insert('logpost_mini', array_keys($list[0]))
                ->values($list)
                ->execute();
        }else{
            $db_user_id = Arr::path($records, ['*', 'user_id']);
            $user_id = Arr::path($list, ['*', 'user_id']) ?: [];

            $diff = array_diff($db_user_id, $user_id);
            foreach ($diff as $d){
                DB::delete('logpost_mini')
                    ->where('user_id', '=', $d)
                    ->and_where('id', '=', $id)
                    ->execute();
            }

            $diff = array_diff($user_id, $db_user_id);
            foreach ($diff as $d){
                foreach ($list as $l){
                    if($l['user_id'] == $d){
                        DB::insert('logpost_mini', array_keys($l))
                            ->values($l)
                            ->execute();
                    }
                }
            }
        }
    }
}